local res = external_profile("Config/Input/Aircrafts/common_keyboard_binding.lua")
local cockpit = folder.."../../../Cockpit/"
dofile(cockpit.."devices.lua")
dofile(cockpit.."command_defs.lua")

join(res.keyCommands,{
    
	-- Weapons Management
	{down = 3249, up = 3249, cockpit_device_id = 6,  value_down = 1, name = _('Selective Jettison ON'), category = _('Weapons Management')},
	{down = 3249, up = 3249, cockpit_device_id = 6,  value_down = 0, name = _('Selective Jettison OFF'), category = _('Weapons Management')},
	{down = 3248, up = 3248, cockpit_device_id = 6,  value_down = 1, name = _('Selective Jettison Safety Cover OPEN'), category = _('Weapons Management')},
	{down = 3248, up = 3248, cockpit_device_id = 6,  value_down = 0, name = _('Selective Jettison Safety Cover CLOSED'), category = _('Weapons Management')},
	{combos = {{key = 'E', reformers = {'LShift'}}}, down = 3409, up = 3409, cockpit_device_id = 6,  value_up = 0, value_down = 1, name = _('Emergency Jettison'), category = _('Weapons Management')},
	{combos = {{key = '0'}}, down = iCommandSwitchMasterArm, name = _('Master Arm TOGGLE'), category = _('Weapons Management')},
	{combos = {{key = '1'}}, down = iCommandPlaneLeftMFD_OSB1, name = _('PCA Button 1 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '2'}}, down = iCommandPlaneLeftMFD_OSB2, name = _('PCA Button 2 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '3'}}, down = iCommandPlaneLeftMFD_OSB3, name = _('PCA Button 3 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '4'}}, down = iCommandPlaneLeftMFD_OSB4, name = _('PCA Button 4 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '5'}}, down = iCommandPlaneLeftMFD_OSB5, name = _('PCA Button 5 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '1', reformers = {'LCtrl'}}}, down = iCommandPlaneLeftMFD_OSB6, name = _('Gun Mode SELECT'), category = _('Weapons Management')},
	{combos = {{key = '2', reformers = {'LCtrl'}}}, down = iCommandPlaneLeftMFD_OSB7, name = _('Magic II SELECT'), category = _('Weapons Management')},
	{combos = {{key = '3', reformers = {'LCtrl'}}}, down = iCommandPlaneLeftMFD_OSB8, name = _('Stores 2 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '4', reformers = {'LCtrl'}}}, down = iCommandPlaneLeftMFD_OSB9, name = _('Stores 3 SELECT'), category = _('Weapons Management')},
	{combos = {{key = '5', reformers = {'LCtrl'}}}, down = iCommandPlaneLeftMFD_OSB10, name = _('Stores 4 SELECT'), category = _('Weapons Management')},
	
	-- Communications
	{combos = {{key = 'I', reformers = {'LWin'}}}, down = iCommandAWACSTankerBearing, name = _('Request AWACS Available Tanker'), category = _('Communications')},
	{combos = {{key = '\\', reformers = {'RShift'}}, {key = 'M', reformers = {'RShift'}}}, down = iCommandToggleReceiveMode, name = _('Receive Mode'), category = _('Communications')},
    {down = 3446, up = 3446, cockpit_device_id = 19, value_down = 0, name = _('U/VHF Radio OFF'), category = _('Communications')},
    {down = 3446, up = 3446, cockpit_device_id = 19, value_down = .25, name = _('U/VHF Radio ON'), category = _('Communications')},
	
	-- Countermeasures
	{combos = {{key = 'Delete'}}, down = iCommandPlaneDropFlareOnce, name = _('Flares DISPENSE'), category = _('Countermeasures')},
	{combos = {{key = 'Insert'}}, down = iCommandPlaneDropChaffOnce, name = _('Chaff DISPENSE'), category = _('Countermeasures')},
	{down = 3606, up = 3606, cockpit_device_id = 13, value_down = 0, name = _('Jammer OFF'), category = _('Countermeasures')},
	{down = 3606, up = 3606, cockpit_device_id = 13, value_down = .5, name = _('Jammer ON'), category = _('Countermeasures')},
	{down = 3606, up = 3606, cockpit_device_id = 13, value_down = 1, name = _('Jammer TEST'), category = _('Countermeasures')},
	{combos = {{key = 'E'}}, down = iCommandActiveJamming, name = _('Jammer ACTIVATE'), category = _('Countermeasures')},
	{down = 3194, up = 3194, cockpit_device_id = 13, value_down = 0, name = _('CM Box OFF'), category = _('Countermeasures')},
	{down = 3194, up = 3194, cockpit_device_id = 13, value_down = .5, name = _('CM Box ON'), category = _('Countermeasures')},
	{down = 3194, up = 3194, cockpit_device_id = 13, value_down = 1, name = _('CM Box AUTO'), category = _('Countermeasures')},
	
	-- Engine & Fuel
	{down = 3647, up = 3647, cockpit_device_id = 4, value_down= 1, name = _('LEFT Fuel Boost Pump ON'), category = _('Engine & Fuel')},
	{down = 3647, up = 3647, cockpit_device_id = 4, value_down= 0, name = _('LEFT Fuel Boost Pump OFF'), category = _('Engine & Fuel')},
	{down = 3648, up = 3648, cockpit_device_id = 4, value_down= 1, name = _('RIGHT Fuel Boost Pump ON'), category = _('Engine & Fuel')},
	{down = 3648, up = 3648, cockpit_device_id = 4, value_down= 0, name = _('RIGHT Fuel Boost Pump OFF'), category = _('Engine & Fuel')},
	{down = 3645, up = 3645, cockpit_device_id = 7, value_down= 0, name = _('Start Button Safety Cover CLOSED'), category = _('Engine & Fuel')},
	{down = 3645, up = 3645, cockpit_device_id = 7, value_down= 1, name = _('Start Button Safety Cover OPEN'), category = _('Engine & Fuel')},
	{down = 3646, up = 3646, cockpit_device_id = 7, value_down= 1, name = _('Starter Fuel Pump ON'), category = _('Engine & Fuel')},
	{down = 3646, up = 3646, cockpit_device_id = 7, value_down= 0, name = _('Starter Fuel Pump OFF'), category = _('Engine & Fuel')},
	{down = 3650, up = 3650, cockpit_device_id = 7, value_down= 1, name = _('Ventilation Selector Switch RIGHT'), category = _('Engine & Fuel')},
	{down = 3650, up = 3650, cockpit_device_id = 7, value_down= .5, name = _('Ventilation Selector Switch LEFT'), category = _('Engine & Fuel')},
	{down = 3650, up = 3650, cockpit_device_id = 7, value_down= 0, name = _('Ventilation Selector Switch OFF'), category = _('Engine & Fuel')},
	{down = 3468, up = 3468, cockpit_device_id = 7, value_down= 0, name = _('In-Flight Start Switch OFF'), category = _('Engine & Fuel')},
	{down = 3468, up = 3468, cockpit_device_id = 7, value_down= 1, name = _('In-Flight Start Switch ON'), category = _('Engine & Fuel')},
	{combos = {{key = 'Home', reformers = {'RShift'}}}, down = iCommandEnginesStart, name = _('Engines START'), category = _('Engine & Fuel')},
	{combos = {{key = 'End', reformers = {'RShift'}}}, down = iCommandEnginesStop, name = _('Engines STOP'), category = _('Engine & Fuel')},
	{combos = {{key = 'R'}}, down = iCommandPlaneFuelOn, up = iCommandPlaneFuelOff, name = _('Fuel Dump START'), category = _('Engine & Fuel')},
	
	-- Flight Control
	{combos = {{key = 'Up'}}, pressed = iCommandPlaneUpStart, up = iCommandPlaneUpStop, name = _('Aircraft Pitch DOWN'), category = _('Flight Control')},
	{combos = {{key = 'Down'}}, pressed = iCommandPlaneDownStart, up = iCommandPlaneDownStop, name = _('Aircraft Pitch UP'), category = _('Flight Control')},
	{combos = {{key = 'Left'}}, pressed = iCommandPlaneLeftStart, up = iCommandPlaneLeftStop, name = _('Aircraft Bank LEFT'), category = _('Flight Control')},
	{combos = {{key = 'Right'}}, pressed = iCommandPlaneRightStart, up = iCommandPlaneRightStop, name = _('Aircraft Bank RIGHT'), category = _('Flight Control')},
	{combos = {{key = 'Z'}}, pressed = iCommandPlaneLeftRudderStart, up = iCommandPlaneLeftRudderStop, name = _('Aircraft Rudder LEFT'), category = _('Flight Control')},
	{combos = {{key = 'X'}}, pressed = iCommandPlaneRightRudderStart, up = iCommandPlaneRightRudderStop, name = _('Aircraft Rudder RIGHT'), category = _('Flight Control')},
	{combos = {{key = 'Num+'}}, pressed = iCommandThrottleIncrease, up = iCommandThrottleStop,  name = _('Throttle UP'), category = _('Flight Control')},
	{combos = {{key = 'Num-'}}, pressed = iCommandThrottleDecrease, up = iCommandThrottleStop,  name = _('Throttle DOWN'), category = _('Flight Control')},
	{combos = {{key = 'B'}}, down = iCommandPlaneAirBrake, name = _('Airbrake TOGGLE'), category = _('Flight Control')},
	{combos = {{key = 'B', reformers = {'LShift'}}}, down = iCommandPlaneAirBrakeOn, name = _('Airbrake ON'), category = _('Flight Control')},
	{combos = {{key = 'B', reformers = {'LCtrl'}}}, down = iCommandPlaneAirBrakeOff, name = _('Airbrake OFF'), category = _('Flight Control')},
	{combos = {{key = 'S', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimUp, up = iCommandPlaneTrimStop, name = _('Trim NOSE UP'), category = _('Flight Control')},
	{combos = {{key = 'W', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimDown, up = iCommandPlaneTrimStop, name = _('Trim NOSE DOWN'), category = _('Flight Control')},
	{combos = {{key = 'A', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeft, up = iCommandPlaneTrimStop, name = _('Trim LEFT WING DOWN'), category = _('Flight Control')},
	{combos = {{key = 'D', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRight, up = iCommandPlaneTrimStop, name = _('Trim RIGHT WING DOWN'), category = _('Flight Control')},
	{combos = {{key = 'Z', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimLeftRudder, up = iCommandPlaneTrimStop, name = _('Trim RUDDER LEFT'), category = _('Flight Control')},
	{combos = {{key = 'X', reformers = {'RCtrl'}}}, pressed = iCommandPlaneTrimRightRudder, up = iCommandPlaneTrimStop, name = _('Trim RUDDER RIGHT'), category = _('Flight Control')},
	{down = 3462, up = 3462, cockpit_device_id = 14, value_down = 0, name = _('Slats RETRACT'), category = _('Flight Control')},
	{down = 3462, up = 3462, cockpit_device_id = 14, value_down = .5, name = _('Slats AUTO'), category = _('Flight Control')},
	{down = 3462, up = 3462, cockpit_device_id = 14, value_down = 1, name = _('Slats EXTEND'), category = _('Flight Control')},
	{down = 3420, up = 3420, cockpit_device_id = 3, value_down = 0, name = _('FBW Gain Cover CLOSED'), category = _('Flight Control')},
	{down = 3420, up = 3420, cockpit_device_id = 3, value_down = 1, name = _('FBW Gain Cover OPEN'), category = _('Flight Control')},
	{down = 3421, up = 3421, cockpit_device_id = 3, value_down = 0, name = _('FBW Gain NORM'), category = _('Flight Control')},
	{down = 3421, up = 3421, cockpit_device_id = 3, value_down = 1, name = _('FBW Gain EMER'), category = _('Flight Control')},
	{combos = {{key = 'G', reformers = {'LCtrl','LShift'}}}, down = iCommandPlaneCobra, name = _('FBW G-Limiter Mode TOGGLE'), category = _('Flight Control')},
	{combos = {{key = 'V', reformers = {'LCtrl','LShift'}}}, down = iCommandPlaneEmerFlightControl, name = _('FBW Spin Switch TOGGLE'), category = _('Flight Control')},
    --{combos = {{key = 'P'}}, down = iCommandPlaneParachute, name = _('Drag Chute DEPLOY'), category = _('Flight Control')},
	
	--HOTAS
	{combos = {{key = 'A', reformers = {'LAlt'}}}, down = iCommandPlaneAutopilotOverrideOn, up = iCommandPlaneAutopilotOverrideOff, name = _('Autopilot Standby Mode'), category = _('HOTAS')},
	{combos = {{key = 'A', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_PinkySwitchAft, up = iCommandPlane_HOTAS_PinkySwitchForward, name = _('Autopilot Disconnect/Exceed Elastic Limit'),  category = _('HOTAS')},
	{combos = {{key = 'Space'}}, down = iCommandPlaneFire, up = iCommandPlaneFireOff, name = _('Weapon FIRE'), category = _('HOTAS')},
	{combos = {{key = 'C'}}, down = iCommandPlaneModeCannon,   name = _('Cannon SELECT'), category = _('HOTAS')},
	{down = iCommandPlaneModeFI0,      name = _('Magic II SELECT'), category = _('HOTAS')},
	{down = iCommandPlaneModeVS,     name = _('Close Air Combat Mode SELECT'), category = _('HOTAS')},
	{down = iCommandPlaneModeHelmet, name = _('Special Modes DESELECT'), category = _('HOTAS')},
	{down = iCommandPlaneModeGrid,   name = _('Ground Avoidance Mode SELECT'), category = _('HOTAS')},
	{combos = {{key = 'Num+', reformers = {'LShift'}}}, down = iCommandPlane_HOTAS_MIC_SwitchUp,    up = iCommandPlane_HOTAS_MIC_SwitchOff, name = _('Main U/VHF Radio SELECT'),    category = _('HOTAS')},
	{combos = {{key = 'Num-', reformers = {'LAlt'}}},   down = iCommandPlane_HOTAS_MIC_SwitchDown,  up = iCommandPlane_HOTAS_MIC_SwitchOff, name = _('Aux. UHF Radio SELECT'),  category = _('HOTAS')},
	{combos = {{key = '-'}}, down = iCommandDecreaseRadarScanArea, name = _('Radar Range DECREASE'), category = _('HOTAS')},
	{combos = {{key = '='}}, down = iCommandIncreaseRadarScanArea, name = _('Radar Range INCREASE'), category = _('HOTAS')},
	{combos = {{key = ';'}}, pressed = iCommandPlaneRadarUp,    up = iCommandPlaneRadarStop, name = _('TDC UP'),     category = _('HOTAS')},
	{combos = {{key = '.'}}, pressed = iCommandPlaneRadarDown,  up = iCommandPlaneRadarStop, name = _('TDC DOWN'),   category = _('HOTAS')},
	{combos = {{key = ','}}, pressed = iCommandPlaneRadarLeft,  up = iCommandPlaneRadarStop, name = _('TDC LEFT'),   category = _('HOTAS')},
	{combos = {{key = '/'}}, pressed = iCommandPlaneRadarRight, up = iCommandPlaneRadarStop, name = _('TDC RIGHT'),  category = _('HOTAS')},
	{down = iCommandPlaneRadarCenter,      name = _('TDC CENTER'), category = _('HOTAS')},
	{combos = {{key = 'Enter'}}, down = iCommandPlaneChangeLock, name = _('Target LOCK'), category = _('HOTAS')},
	{combos = {{key = 'Back'}},  down = iCommandRefusalTWS, name = _('Target CANCEL LOCK'), category = _('HOTAS')},
	{combos = {{key = 'S'}},     down = iCommandPlane_HOTAS_BoatSwitchAft, up = iCommandPlane_HOTAS_BoatSwitchForward, name = _('Nosewheel Steering/IFF Interrogate'), category = _('HOTAS')},
	
	-- External Illumination
	{down = 3449, up = 3449, cockpit_device_id = 16, value_down = 0, name = _('Police Lights OFF'), category = _('External Illumination')},
	{down = 3449, up = 3449, cockpit_device_id = 16, value_down = 1, name = _('Police Lights ON'), category = _('External Illumination')},
	{down = 3450, up = 3450, cockpit_device_id = 16, value_down = 0, name = _('Landing Lights OFF'), category = _('External Illumination')},
	{down = 3450, up = 3450, cockpit_device_id = 16, value_down = 1, name = _('Landing Lights ON'), category = _('External Illumination')},
	{combos = {{key = 'L', reformers = {'RAlt'}}},  down = iCommandPlaneHeadLightOnOff, name = _('Landing Lights TOGGLE'), category = _('External Illumination')},
	{down = 3452, up = 3452, cockpit_device_id = 16, value_down = 0, name = _('Refuel Lights OFF'), category = _('External Illumination')},
	{down = 3452, up = 3452, cockpit_device_id = 16, value_down = 1, name = _('Refuel Lights ON'), category = _('External Illumination')},
	{down = 3453, up = 3453, cockpit_device_id = 16, value_down = 0, name = _('Anti-Collision Lights OFF'), category = _('External Illumination')},
	{down = 3453, up = 3453, cockpit_device_id = 16, value_down = 1, name = _('Anti-Collision Lights ON'), category = _('External Illumination')},
	{combos = {{key = 'L', reformers = {'RShift','RCtrl'}}}, down = iCommandPlaneAntiCollisionLights, name = _('Anti-Collision Lights TOGGLE'), category = _('External Illumination')},
	{down = 3454, up = 3454, cockpit_device_id = 16, value_down = 0, name = _('Navigation Lights OFF'), category = _('External Illumination')},
	{down = 3454, up = 3454, cockpit_device_id = 16, value_down = 1, name = _('Navigation Lights ON'), category = _('External Illumination')},
	{combos = {{key = 'L', reformers = {'RCtrl'}}}, down = iCommandPlaneLightsOnOff, name = _('Navigation Lights TOGGLE'), category = _('External Illumination')},
	{down = 3455, up = 3455, cockpit_device_id = 16, value_down = 0, name = _('Formation Lights OFF'), category = _('External Illumination')},
	{down = 3455, up = 3455, cockpit_device_id = 16, value_down = 1, name = _('Formation Lights ON'), category = _('External Illumination')},
	{combos = {{key = 'L', reformers = {'RCtrl'}}}, down = iCommandPlaneFormationLights, name = _('Formation Lights TOGGLE'), category = _('External Illumination')},
	
	-- Sensors
	--Radar
	{pressed = iCommandSelecterUp, up = iCommandSelecterStop, name = _('Radar Antenna UP'), category = _('Sensors')},
	{pressed = iCommandSelecterDown, up = iCommandSelecterStop, name = _('Radar Antenna DOWN'), category = _('Sensors')},
	{pressed = iCommandSelecterLeft, up = iCommandSelecterStop, name = _('Radar Antenna LEFT'), category = _('Sensors')},
	{pressed = iCommandSelecterRight, up = iCommandSelecterStop, name = _('Radar Antenna RIGHT'), category = _('Sensors')},
	
	{down = 3506, up = 3506, cockpit_device_id = 11, value_down = 0, name = _('Radar Azimuth WIDE'), category = _('Sensors')},
	{down = 3506, up = 3506, cockpit_device_id = 11, value_down = .5, name = _('Radar Azimuth MIDDLE'), category = _('Sensors')},
	{down = 3506, up = 3506, cockpit_device_id = 11, value_down = 1, name = _('Radar Azimuth NARROW'), category = _('Sensors')},
	
	{down = 3502, up = 3502, cockpit_device_id = 11, value_down = 0, name = _('Radar Scan 4-LINE'), category = _('Sensors')},
	{down = 3502, up = 3502, cockpit_device_id = 11, value_down = .5, name = _('Radar Scan 2-LINE'), category = _('Sensors')},
	{down = 3502, up = 3502, cockpit_device_id = 11, value_down = 1, name = _('Radar Scan 1-LINE'), category = _('Sensors')},
	
	{down = 3486, up = 3486, cockpit_device_id = 11, value_down = 0, name = _('Radar OFF'), category = _('Sensors')},
	{down = 3486, up = 3486, cockpit_device_id = 11, value_down = .33, name = _('Radar START'), category = _('Sensors')},
	{down = 3486, up = 3486, cockpit_device_id = 11, value_down = .67, name = _('Radar STANDBY'), category = _('Sensors')},
	{down = 3486, up = 3486, cockpit_device_id = 11, value_down = 1, name = _('Radar ON'), category = _('Sensors')},
	
	{down = 3499, up = 3499, cockpit_device_id = 11, value_down = 0, name = _('Radar PPI Mode (Radial Top-Down)'), category = _('Sensors')},
	{down = 3499, up = 3499, cockpit_device_id = 11, value_down = 1, name = _('Radar B-Scope Mode (Square Projection)'), category = _('Sensors')},
	
	--Radar IFF
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0,   name = _('Radar IFF Mode 1'),   category = _('Sensors')},
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.2, name = _('Radar IFF Mode 4'),   category = _('Sensors')},
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.4, name = _('Radar IFF Mode 3/2'), category = _('Sensors')},
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.6, name = _('Radar IFF Mode 3/3'), category = _('Sensors')},
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 0.8, name = _('Radar IFF Mode 3/4'), category = _('Sensors')},
	{down = 3598, up = 3598, cockpit_device_id = 11, value_down = 1,   name = _('Radar IFF Mode 2'),   category = _('Sensors')},
	{down = 3599, up = 3599, cockpit_device_id = 11, value_down = 0,   name = _('Radar IFF L Selector'), category = _('Sensors')},
	{down = 3599, up = 3599, cockpit_device_id = 11, value_down = 1,   name = _('Radar IFF R Selector'), category = _('Sensors')},
	{down = 3600, up = 3600, cockpit_device_id = 11, value_down = 0,   name = _('Radar IFF OFF'),     category = _('Sensors')},
	{down = 3600, up = 3600, cockpit_device_id = 11, value_down = 0.5, name = _('Radar IFF SECTOR'), category = _('Sensors')},
	{down = 3600, up = 3600, cockpit_device_id = 11, value_down = 1,   name = _('Radar IFF CONT'),   category = _('Sensors')},
	
	--RWR
	{down = 3607, up = 3607, cockpit_device_id = 13, value_down = 0, name = _('RWR OFF'), category = _('Sensors')},
    {down = 3607, up = 3607, cockpit_device_id = 13, value_down = .5, name = _('RWR ON'), category = _('Sensors')},
    {down = 3607, up = 3607, cockpit_device_id = 13, value_down = 1, name = _('RWR TEST'), category = _('Sensors')},
	
	--RADALT
    {down = 3205, up = 3205, cockpit_device_id = 5, value_down = 0, name = _('Radar Altimeter OFF'), category = _('Sensors')},
    {down = 3205, up = 3205, cockpit_device_id = 5, value_down = 0.5, name = _('Radar Altimeter ON'), category = _('Sensors')},
    {down = 3205, up = 3205, cockpit_device_id = 5, value_down = 1, name = _('Radar Altimeter TEST'), category = _('Sensors')},
	
    -- Electrical
	{down = 3520, up = 3520, cockpit_device_id = 8, value_down= 0, name = _('Main Battery OFF'), category = _('Electrical')},
	{down = 3520, up = 3520, cockpit_device_id = 8, value_down= 1, name = _('Main Battery ON'), category = _('Electrical')},
	{combos = {{key = 'B', reformers = {'LShift','LCtrl'}}}, down = iCommandBatteryPower, name = _('Main Battery TOGGLE'), category = _('Electrical')},
	{down = 3521, up = 3521, cockpit_device_id = 8, value_down= 0, name = _('Electric Power Transfer OFF'), category = _('Electrical')},
	{down = 3521, up = 3521, cockpit_device_id = 8, value_down= 1, name = _('Electric Power Transfer ON'), category = _('Electrical')},
	{down = 3522, up = 3522, cockpit_device_id = 8, value_down= 0, name = _('Alternator 1 OFF'), category = _('Electrical')},
	{down = 3522, up = 3522, cockpit_device_id = 8, value_down= 1, name = _('Alternator 1 ON'), category = _('Electrical')},
	{down = 3523, up = 3523, cockpit_device_id = 8, value_down= 0, name = _('Alternator 2 OFF'), category = _('Electrical')},
	{down = 3523, up = 3523, cockpit_device_id = 8, value_down= 1, name = _('Alternator 2 ON'), category = _('Electrical')},

    -- Cockpit Displays & Illumination
    {down = 3639, up = 3639, cockpit_device_id = 16, value_down = 0, name = _('Dashboard Flood Lights OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3639, up = 3639, cockpit_device_id = 16, value_down = .33, name = _('Dashboard Flood Lights LOW'), category = _('Cockpit Displays & Illumination')},
    {down = 3639, up = 3639, cockpit_device_id = 16, value_down = .67, name = _('Dashboard Flood Lights MEDIUM'), category = _('Cockpit Displays & Illumination')},
    {down = 3639, up = 3639, cockpit_device_id = 16, value_down = 1, name = _('Dashboard Flood Lights HIGH'), category = _('Cockpit Displays & Illumination')},
    {down = 3640, up = 3640, cockpit_device_id = 16, value_down = 0, name = _('Dashboard Panel Lights OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3640, up = 3640, cockpit_device_id = 16, value_down = .33, name = _('Dashboard Panel Lights LOW'), category = _('Cockpit Displays & Illumination')},
    {down = 3640, up = 3640, cockpit_device_id = 16, value_down = .67, name = _('Dashboard Panel Lights MEDIUM'), category = _('Cockpit Displays & Illumination')},
    {down = 3640, up = 3640, cockpit_device_id = 16, value_down = 1, name = _('Dashboard Panel Lights HIGH'), category = _('Cockpit Displays & Illumination')},
    {down = 3641, up = 3641, cockpit_device_id = 16, value_down = 0, name = _('Console Flood Lights OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3641, up = 3641, cockpit_device_id = 16, value_down = .33, name = _('Console Flood Lights LOW'), category = _('Cockpit Displays & Illumination')},
    {down = 3641, up = 3641, cockpit_device_id = 16, value_down = .67, name = _('Console Flood Lights MEDIUM'), category = _('Cockpit Displays & Illumination')},
    {down = 3641, up = 3641, cockpit_device_id = 16, value_down = 1, name = _('Console Flood Lights HIGH'), category = _('Cockpit Displays & Illumination')},
    {down = 3642, up = 3642, cockpit_device_id = 16, value_down = 0, name = _('Console Panel Lights OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3642, up = 3642, cockpit_device_id = 16, value_down = .33, name = _('Console Panel Lights LOW'), category = _('Cockpit Displays & Illumination')},
    {down = 3642, up = 3642, cockpit_device_id = 16, value_down = .67, name = _('Console Panel Lights MEDIUM'), category = _('Cockpit Displays & Illumination')},
    {down = 3642, up = 3642, cockpit_device_id = 16, value_down = 1, name = _('Console Panel Lights HIGH'), category = _('Cockpit Displays & Illumination')},
    {down = 3201, up = 3201, cockpit_device_id = 5, value_down = 0, name = _('HUD OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3201, up = 3201, cockpit_device_id = 5, value_down = .5, name = _('HUD ON'), category = _('Cockpit Displays & Illumination')},
    {down = 3201, up = 3201, cockpit_device_id = 5, value_down = 1, name = _('HUD TEST'), category = _('Cockpit Displays & Illumination')},
    {pressed = iCommandHUDBrightnessUp, name = _('HUD Brightness UP'), category = _('Cockpit Displays & Illumination')},
    {pressed = iCommandHUDBrightnessDown, name = _('HUD Brightness DOWN'), category = _('Cockpit Displays & Illumination')},
    {down = 3524, up = 3524, cockpit_device_id = 8, value_up= 0, value_down= 1, name = _('Warning Lights TEST'), category = _('Cockpit Displays & Illumination')},
    {combos = {{key = 'R', reformers = {'LCtrl'}}},  down = iCommandPlaneResetMasterWarning, up = iCommandPlaneResetMasterWarning, name = _('Master Caution RESET'), category = _('Cockpit Displays & Illumination')},
    {down = iCommandPlaneCDU_CLR, name = _('VTB Viewport ON/OFF'), category = _('Cockpit Displays & Illumination')},
    {combos = {{key = 'C', reformers = {'RShift'}}}, down = iCommandFlightClockReset, name = _('Flight Clock START/STOP/RESET'), category = _('Cockpit Displays & Illumination')},
    {down = iCommandClockElapsedTimeReset, name = _('Elapsed Time Clock START/STOP/RESET'), category = _('Cockpit Displays & Illumination')},
    {down = 3221, up = 3221, cockpit_device_id = 5, value_down = 0, name = _('Radar Screen OFF'), category = _('Cockpit Displays & Illumination')},
    {down = 3221, up = 3221, cockpit_device_id = 5, value_down = 1, name = _('Radar Screen ON'), category = _('Cockpit Displays & Illumination')},
    {down = iCommandPlaneZoomIn, name = _('HDD Zoom IN'), category = _('Cockpit Displays & Illumination')},
    {down = iCommandPlaneZoomOut, name = _('HDD Zoom OUT'), category = _('Cockpit Displays & Illumination')},
    
    -- Hydraulic & Mechanical
    {down = 3657, up = 3657, cockpit_device_id = 3, value_down= 0, name = _('Hydraulic Emergency Pump OFF'), category = _('Hydraulic & Mechanical')},
    {down = 3657, up = 3657, cockpit_device_id = 3, value_down= 1, name = _('Hydraulic Emergency Pump ON'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'W'}}, down = iCommandPlaneWheelBrakeOn, up = iCommandPlaneWheelBrakeOff, name = _('Wheel Brakes'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'W', reformers = {'LShift'}}}, down = iCommandPlaneWheelBrakeLeftOn, up = iCommandPlaneWheelBrakeLeftOff, name = _('Wheel Brake LEFT'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'W', reformers = {'LAlt'}}},   down = iCommandPlaneWheelBrakeRightOn, up = iCommandPlaneWheelBrakeRightOff, name = _('Wheel Brake RIGHT'), category = _('Hydraulic & Mechanical')},
    {down = 3666, up = 3666, cockpit_device_id = 22, value_down= 0, name = _('Parking Brake OFF'), category = _('Hydraulic & Mechanical')},
    {down = 3666, up = 3666, cockpit_device_id = 22, value_down= 1, name = _('Parking Brake ON'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'G'}}, down = iCommandPlaneGear, name = _('Landing Gear TOGGLE'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'G', reformers = {'LCtrl'}}}, down = iCommandPlaneGearUp, name = _('Landing Gear UP'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'G', reformers = {'LShift'}}}, down = iCommandPlaneGearDown, name = _('Landing Gear DOWN'), category = _('Hydraulic & Mechanical')},
    {combos = {{key = 'C', reformers = {'LCtrl'}}}, down = iCommandPlaneFonar, name = _('Canopy Position CYCLE'), category = _('Hydraulic & Mechanical')},

    -- Autopilot, Navigation, & INS
    {down = iCommandPlaneChangeTarget  , name = ('Next Waypoint, Airfield or Target'), category = ('Autopilot, Navigation, & INS')},
    {down = iCommandPlaneUFC_STEER_DOWN, name = ('Previous Waypoint, Airfield or Target'), category = ('Autopilot, Navigation, & INS')},
    {combos = {{key = '=', reformers = {'RShift'}}}, pressed = iCommandAltimeterPressureIncrease, up = iCommandAltimeterPressureStop, name = _('Alt Pressure INCREASE'), category = _('Autopilot, Navigation, & INS')},
    {combos = {{key = '-', reformers = {'RShift'}}}, pressed = iCommandAltimeterPressureDecrease, up = iCommandAltimeterPressureStop, name = _('Alt Pressure DECREASE'), category = _('Autopilot, Navigation, & INS')},
    {combos = {{key = 'A'}}, down = iCommandPlaneAutopilot, name = _('Autopilot'), category = _('Autopilot, Navigation, & INS')},
    {combos = {{key = 'H'}}, down = iCommandPlaneStabHbar,  name = _('Altitude Hold Mode'), category = _('Autopilot, Navigation, & INS')},
    {combos = {{key = 'H', reformers = {'LShift'}}}, down = iCommandPlaneSAUHBarometric, name = _('Selected Altitude Hold Mode'), category = _('Autopilot, Navigation, & INS')},
    {combos = {{key = 'F'}}, down = iCommandPlaneRouteAutopilot, name = _('Approach Hold Mode'), category = _('Autopilot, Navigation, & INS')},

	-- Pilot & Seat Controls
    {combos = {{key = 'L', reformers = {'LAlt','LCtrl'}}},  down = iCommandPlaneCockpitIllumination, name = _('Flashlight TOGGLE'), category = _('Pilot & Seat Controls')},
    {combos={{key='Home',reformers={'LAlt'}}},down=3906,cockpit_device_id=22,name=_('Helmet Visor TOGGLE'),category=_('Pilot & Seat Controls')},
	{combos = {{key = 'P', reformers = {'RShift'}}}, down = iCommandCockpitShowPilotOnOff, name = _('Pilot Body TOGGLE'), category = _('Pilot & Seat Controls')},
	{combos = {{key = 'M', reformers = {'LShift'}}}, down = iCommandToggleMirrors, name = _('Mirrors TOGGLE'), category = _('Pilot & Seat Controls')},
	{combos = {{key = 'S', reformers = {'LShift'}}},        pressed = iCommandPilotSeatAdjustmentUp  ,  up = iCommandPilotSeatAdjustmentStop, name = _('Seat RAISE'),   category = _('Pilot & Seat Controls')},
	{combos = {{key = 'S', reformers = {'LShift','LAlt'}}}, pressed = iCommandPilotSeatAdjustmentDown,  up = iCommandPilotSeatAdjustmentStop, name = _('Seat LOWER'), category = _('Pilot & Seat Controls')},
    {combos = {{key = 'E', reformers = {'LCtrl'}}}, down = iCommandPlaneEject, name = _('Eject (3 times)'), category = _('Pilot & Seat Controls')},
	-- BKS NVG MOD
    {combos = {{key = 'H', reformers = {'RShift'}}}    , down = iCommandViewNightVisionGogglesOn , name = _('Night Vision Goggles') , category = _('Sensors')},
    {combos = {{key = 'H', reformers = {'RCtrl','RShift'}}}, pressed = iCommandPlane_Helmet_Brightess_Up , name = _('Night Vision Goggles Gain Up') , category = _('Sensors')},
    {combos = {{key = 'H', reformers = {'RAlt','RShift'}}} , pressed = iCommandPlane_Helmet_Brightess_Down, name = _('Night Vision Goggles Gain Down'), category = _('Sensors')},
}) return res